import 'package:flutter/material.dart';
import 'package:wordpress_app/models/article.dart';

class CategoryChip extends StatelessWidget {
  final Article article;
  const CategoryChip({super.key, required this.article});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(
        horizontal: 12,
        vertical: 3,
      ),
      decoration: BoxDecoration(
        color: Colors.green,
        borderRadius: BorderRadius.circular(30),
      ),
      child: Text(
        article.category.toString(),
        style: Theme.of(context)
            .textTheme
            .labelSmall
            ?.copyWith(fontWeight: FontWeight.w600, color: Colors.white),
      ),
    );
  }
}
